<?php

/*============================*\
|| ########################## ||
|| # All Albums version 1.0 # ||
|| ########################## ||
\*============================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'album');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('album', 'user');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates used by all actions
$globaltemplates = array(
	'memberinfo_usercss',
	'album_list',
	'albumbit'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_album.php');
require_once(DIR . '/includes/functions_user.php');

if (!
	(
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_albums']
		AND
		$permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']
		AND
		$permissions['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canviewalbum']
	)
)
{
	print_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

	$vbulletin->input->clean_array_gpc('r', array(
		'pagenumber' => TYPE_UINT
	));

	$state = array('public');
	if (can_view_private_albums($userinfo['userid']))
	{
		$state[] = 'private';
	}
	if (can_view_profile_albums($userinfo['userid']))
	{
		$state[] = 'profile';
	}

	$albumcount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "album
		WHERE state IN ('" . implode("', '", $state) . "')
	");

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	$perpage = $vbulletin->options['albums_perpage'];
	$total_pages = max(ceil($albumcount['total'] / $perpage), 1); // handle the case of 0 albums
	$pagenumber = ($vbulletin->GPC['pagenumber'] > $total_pages ? $total_pages : $vbulletin->GPC['pagenumber']);
	$start = ($pagenumber - 1) * $perpage;

	// fetch data and prepare data
	$albums = $db->query_read("
		SELECT album.*,
			picture.pictureid, picture.extension, picture.idhash,
			picture.thumbnail_dateline, picture.thumbnail_width, picture.thumbnail_height
			$hook_query_fields
		FROM " . TABLE_PREFIX . "album AS album
		LEFT JOIN " . TABLE_PREFIX . "picture AS picture ON (album.coverpictureid = picture.pictureid AND picture.thumbnail_filesize > 0)
		$hook_query_joins
		WHERE album.state IN ('" . implode("', '", $state) . "')
			$hook_query_where
		ORDER BY album.lastpicturedate DESC
		LIMIT $start, $perpage
	");

	$albumbits = '';
	while ($album = $db->fetch_array($albums))
	{
		$album['picturecount'] = vb_number_format($album['picturecount']);
		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
		$album['picturetime'] = vbdate($vbulletin->options['timeformat'], $album['lastpicturedate']);

		$album['description_html'] = nl2br(fetch_word_wrapped_string(fetch_censored_text($album['description'])));
		$album['title_html'] = fetch_word_wrapped_string(fetch_censored_text($album['title']));

		$album['coverthumburl'] = ($album['pictureid'] ? fetch_picture_url($album, $album, true) : '');
		$album['coverdimensions'] = ($album['thumbnail_width'] ? "width=\"$album[thumbnail_width]\" height=\"$album[thumbnail_height]\"" : '');

		if ($album['state'] == 'private')
		{
			$show['personalalbum'] = true;
			$albumtype = $vbphrase['private_album_paren'];
		}
		else if ($album['state'] == 'profile')
		{
			$show['personalalbum'] = true;
			$albumtype = $vbphrase['profile_album_paren'];
		}
		else
		{
			$show['personalalbum'] = false;
		}

		($hook = vBulletinHook::fetch_hook('album_user_albumbit')) ? eval($hook) : false;

		eval('$albumbits .= "' . fetch_template('albumbit') . '";');
	}

	$pagenav = construct_page_nav($pagenumber, $perpage, $albumcount['total'],
		'all_albums.php?' . $vbulletin->session->vars['sessionurl'], ''
	);

	$show['add_album_option'] = ($userinfo['userid'] == $vbulletin->userinfo['userid']);

	$userinfo['username'] = 'All User';

	// navbar and final output
	$navbits = construct_navbits(array(
		'all_albums.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase['xs_profile'], $userinfo['username']),
		'' => $vbphrase['albums']
	));
	eval('$navbar = "' . fetch_template('navbar') . '";');

	eval('print_output("' . fetch_template('album_list') . '");');

?>
